<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seller_domains', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('domain')->unique(); // e.g., "sellerdomain.net"
            $table->boolean('is_primary')->default(false); // Primary domain for seller
            $table->boolean('is_active')->default(false); // Domain is active and verified
            $table->string('verification_token')->nullable(); // For domain ownership verification
            $table->timestamp('verified_at')->nullable(); // When domain was verified
            $table->foreignId('default_sales_page_id')->nullable()->constrained('sales_pages')->onDelete('set null'); // Root domain shows this page
            $table->text('cloudflare_record_id')->nullable(); // Store Cloudflare DNS record ID for API management
            $table->text('notes')->nullable(); // Admin notes or configuration details
            $table->timestamps();

            // Indexes for faster lookups
            $table->index('domain');
            $table->index('user_id');
            $table->index(['user_id', 'is_primary']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seller_domains');
    }
};
