<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Modify the role enum to include 'manager'
        DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'seller', 'manager') NOT NULL DEFAULT 'seller'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove 'manager' from enum (but only if no users have that role)
        DB::statement("ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'seller') NOT NULL DEFAULT 'seller'");
    }
};
