<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales_pages', function (Blueprint $table) {
            $table->boolean('order_bump_enabled')->default(false)->after('faq_items');
            $table->unsignedBigInteger('order_bump_product_id')->nullable()->after('order_bump_enabled');
            $table->text('order_bump_text')->nullable()->after('order_bump_product_id');
            $table->string('order_bump_bg_color', 7)->default('#fef3c7')->after('order_bump_text'); // Yellow background
            $table->string('order_bump_text_color', 7)->default('#78350f')->after('order_bump_bg_color'); // Dark brown text
            $table->string('order_bump_border_style', 20)->default('dashed')->after('order_bump_text_color'); // solid, dashed, dotted
            $table->string('order_bump_border_color', 7)->default('#f59e0b')->after('order_bump_border_style'); // Orange border
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_pages', function (Blueprint $table) {
            $table->dropColumn([
                'order_bump_enabled',
                'order_bump_product_id',
                'order_bump_text',
                'order_bump_bg_color',
                'order_bump_text_color',
                'order_bump_border_style',
                'order_bump_border_color',
            ]);
        });
    }
};
