<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Payment Gateway Settings
            $table->boolean('use_own_payment_gateway')->default(false)->after('sales_page_limit');
            $table->string('bayarcash_portal_key', 255)->nullable()->after('use_own_payment_gateway');
            $table->text('bayarcash_pat')->nullable()->after('bayarcash_portal_key');
            $table->string('bayarcash_secret_key', 255)->nullable()->after('bayarcash_pat');
            $table->enum('bayarcash_environment', ['sandbox', 'production'])->default('sandbox')->after('bayarcash_secret_key');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'use_own_payment_gateway',
                'bayarcash_portal_key',
                'bayarcash_pat',
                'bayarcash_secret_key',
                'bayarcash_environment',
            ]);
        });
    }
};
