<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales_page_orders', function (Blueprint $table) {
            $table->string('payment_method', 20)->nullable()->after('total_amount'); // fpx, duitnow, cod
            $table->string('payment_status', 20)->default('pending')->after('payment_method'); // pending, paid, failed
            $table->decimal('cod_fee', 10, 2)->default(0)->after('payment_status');
            $table->decimal('grand_total', 10, 2)->default(0)->after('cod_fee'); // total_amount + cod_fee

            $table->index('payment_method');
            $table->index('payment_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_page_orders', function (Blueprint $table) {
            $table->dropIndex(['payment_method']);
            $table->dropIndex(['payment_status']);

            $table->dropColumn([
                'payment_method',
                'payment_status',
                'cod_fee',
                'grand_total',
            ]);
        });
    }
};
