<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_page_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_page_order_id')->constrained()->onDelete('cascade');

            // Payment Details
            $table->string('payment_method', 20); // fpx, duitnow, cod
            $table->string('bayarcash_order_number')->nullable(); // BayarCash order ID
            $table->text('bayarcash_payment_url')->nullable(); // Redirect URL for payment
            $table->string('status', 20)->default('pending'); // pending, paid, failed, expired
            $table->decimal('amount', 10, 2);

            // BayarCash Response Data
            $table->json('transaction_data')->nullable();

            // Payment Completion
            $table->timestamp('paid_at')->nullable();
            $table->timestamp('expires_at')->nullable();

            $table->timestamps();

            $table->index('bayarcash_order_number');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_page_payments');
    }
};
