<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_page_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_page_id')->constrained()->onDelete('cascade');
            $table->foreignId('order_id')->nullable()->constrained()->onDelete('set null');

            // Customer Info
            $table->string('customer_name');
            $table->string('customer_email')->nullable();
            $table->string('customer_phone', 50);
            $table->text('customer_address');
            $table->string('customer_city', 100);
            $table->string('customer_state', 100);
            $table->string('customer_postcode', 20);

            // Order Items (JSON)
            $table->json('items'); // [{product_id: 1, qty: 2, price: 50, name: "Product"}]
            $table->decimal('total_amount', 10, 2);

            // Analytics
            $table->string('session_id', 100)->nullable();
            $table->json('utm_data')->nullable();

            // Status
            $table->string('status', 50)->default('pending'); // pending/confirmed/cancelled

            $table->timestamps();

            $table->index('status');
            $table->index('session_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_page_orders');
    }
};
