<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_page_analytics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_page_id')->constrained()->onDelete('cascade');

            $table->string('event_type', 50); // view/order/click

            // Visitor Info
            $table->string('session_id', 100)->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();

            // Traffic Source
            $table->text('referrer')->nullable();
            $table->string('utm_source', 100)->nullable();
            $table->string('utm_medium', 100)->nullable();
            $table->string('utm_campaign', 100)->nullable();
            $table->string('utm_content', 100)->nullable();

            // Device Info
            $table->string('device_type', 20)->nullable(); // mobile/tablet/desktop
            $table->string('browser', 50)->nullable();
            $table->string('os', 50)->nullable();

            $table->timestamp('created_at')->useCurrent();

            $table->index(['sales_page_id', 'event_type']);
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_page_analytics');
    }
};
