<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_pages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // Basic Info
            $table->string('name');
            $table->string('slug')->unique();

            // Content (Simple HTML)
            $table->longText('html_content')->nullable();

            // Available Products (JSON array of product IDs)
            $table->json('available_products')->nullable();

            // Domain Settings
            $table->string('custom_domain')->nullable();
            $table->boolean('custom_domain_verified')->default(false);

            // Tracking Pixels
            $table->string('facebook_pixel_id', 50)->nullable();
            $table->string('google_analytics_id', 50)->nullable();
            $table->string('tiktok_pixel_id', 50)->nullable();

            // Settings
            $table->string('logo_path')->nullable();
            $table->string('primary_color', 7)->default('#3B82F6');

            // Status
            $table->boolean('is_active')->default(true);

            // Cached Stats
            $table->integer('total_views')->default(0);
            $table->integer('total_orders')->default(0);

            $table->timestamps();

            $table->index('slug');
            $table->index('custom_domain');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_pages');
    }
};
