<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            // Tracking webhook event data
            $table->json('poslaju_tracking_events')->nullable()->after('poslaju_response');

            // Last tracking status update
            $table->string('last_tracking_status')->nullable()->after('poslaju_tracking_events');
            $table->timestamp('last_tracking_update')->nullable()->after('last_tracking_status');

            // Auto-completion tracking
            $table->timestamp('delivery_completed_at')->nullable()->after('last_tracking_update');
            $table->boolean('auto_completed_by_webhook')->default(false)->after('delivery_completed_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'poslaju_tracking_events',
                'last_tracking_status',
                'last_tracking_update',
                'delivery_completed_at',
                'auto_completed_by_webhook'
            ]);
        });
    }
};
