<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('poslaju_settings', function (Blueprint $table) {
            // Required fields based on Pos Laju API error response
            $table->string('product_code')->nullable()->after('account_number'); // Product_Code (e.g., "PL")
            $table->string('subscription_code')->nullable()->after('product_code'); // Subscription_Code
            $table->string('item_type')->default('Parcel')->after('subscription_code'); // Item_Type (Parcel/Document)
            $table->string('service_level')->default('Standard')->after('item_type'); // Service_Level (Standard/Express)
            $table->integer('order_validity')->default(1)->after('service_level'); // Order_Validity (days)
            $table->boolean('webhook_required')->default(false)->after('order_validity'); // Webhook_IsRequired
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('poslaju_settings', function (Blueprint $table) {
            $table->dropColumn([
                'product_code',
                'subscription_code',
                'item_type',
                'service_level',
                'order_validity',
                'webhook_required',
            ]);
        });
    }
};
