<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Add WasapBot.my (unofficial WhatsApp) support fields
     */
    public function up(): void
    {
        Schema::table('whatsapp_settings', function (Blueprint $table) {
            // WasapBot.my specific fields
            $table->string('wasapbot_instance_id')->nullable()->after('access_token');
            $table->string('wasapbot_port')->nullable()->after('wasapbot_instance_id');
            $table->string('wasapbot_phone_number')->nullable()->after('wasapbot_port');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('whatsapp_settings', function (Blueprint $table) {
            $table->dropColumn([
                'wasapbot_instance_id',
                'wasapbot_port',
                'wasapbot_phone_number',
            ]);
        });
    }
};
