<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * WhatsApp notification settings for sending order updates to customers
     */
    public function up(): void
    {
        Schema::create('whatsapp_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // API Configuration
            $table->string('provider')->default('official'); // official, twilio, wati, etc.
            $table->string('api_url')->nullable();
            $table->string('api_key')->nullable();
            $table->string('api_secret')->nullable();
            $table->string('phone_number_id')->nullable(); // WhatsApp Business Phone Number ID
            $table->string('business_account_id')->nullable();
            $table->string('access_token')->nullable();

            // Notification Triggers
            $table->boolean('notify_on_order_created')->default(false);
            $table->boolean('notify_on_order_processing')->default(false);
            $table->boolean('notify_on_order_completed')->default(true);
            $table->boolean('notify_on_order_cancelled')->default(false);
            $table->boolean('notify_on_awb_generated')->default(true);

            // Message Templates
            $table->text('template_order_created')->nullable();
            $table->text('template_order_processing')->nullable();
            $table->text('template_order_completed')->nullable();
            $table->text('template_order_cancelled')->nullable();
            $table->text('template_awb_generated')->nullable();

            // Settings
            $table->boolean('is_active')->default(false);
            $table->string('sender_name')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whatsapp_settings');
    }
};
