<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Add OAuth 2.0 fields for Pos Laju authentication
     */
    public function up(): void
    {
        Schema::table('poslaju_settings', function (Blueprint $table) {
            // OAuth 2.0 Credentials
            $table->string('app_code')->nullable()->after('secret_key');
            $table->string('secret_code')->nullable()->after('app_code');
            $table->string('client_id')->nullable()->after('secret_code');
            $table->string('client_secret')->nullable()->after('client_id');

            // OAuth 2.0 Access Token (generated from credentials)
            $table->text('access_token')->nullable()->after('client_secret');
            $table->timestamp('token_expires_at')->nullable()->after('access_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('poslaju_settings', function (Blueprint $table) {
            $table->dropColumn([
                'app_code',
                'secret_code',
                'client_id',
                'client_secret',
                'access_token',
                'token_expires_at'
            ]);
        });
    }
};
