<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('poslaju_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('api_key')->nullable();
            $table->string('secret_key')->nullable();
            $table->string('account_number')->nullable(); // Company Account Number (8800564892)
            $table->string('poslaju_account_id')->nullable(); // Poslaju Account ID (80000000)
            $table->string('sender_name')->nullable();
            $table->string('sender_phone')->nullable();
            $table->string('sender_address')->nullable();
            $table->string('sender_postcode')->nullable();
            $table->string('sender_city')->nullable();
            $table->string('sender_state')->nullable();
            $table->string('poslaju_logo_path')->nullable();
            $table->string('company_logo_path')->nullable();
            $table->decimal('default_weight', 8, 2)->default(0.3);
            $table->string('default_dimension_l')->default('1');
            $table->string('default_dimension_w')->default('1');
            $table->string('default_dimension_h')->default('1');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('poslaju_settings');
    }
};
