<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Order;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update all existing orders to use new OMS ID format
        echo "Updating order IDs to OMS format...\n";

        $orders = Order::all();
        $totalOrders = $orders->count();
        $updated = 0;

        foreach ($orders as $order) {
            // Generate new OMS ID based on database ID
            $number = $order->id;

            if ($number < 1000000) {
                $newOmsId = 'OMS-' . str_pad($number, 6, '0', STR_PAD_LEFT);
            } elseif ($number < 10000000) {
                $newOmsId = 'OMS-' . str_pad($number, 7, '0', STR_PAD_LEFT);
            } else {
                $newOmsId = 'OMS-' . $number;
            }

            // Update the order without triggering model events
            \DB::table('orders')
                ->where('id', $order->id)
                ->update(['global_order_id' => $newOmsId]);

            $updated++;

            if ($updated % 100 === 0) {
                echo "  Updated {$updated}/{$totalOrders} orders...\n";
            }
        }

        echo "✓ Successfully updated {$updated} orders to OMS ID format\n";
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        echo "Warning: Cannot reverse OMS ID migration - old IDs were not preserved.\n";
        echo "If you need to rollback, you'll need to restore from backup.\n";
    }
};
