<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('webhook_sources', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Contact Form", "Payment Form"
            $table->string('type')->default('generic'); // generic, stripe, paypal, etc.
            $table->string('webhook_token')->unique(); // Unique token for this webhook
            $table->string('secret_key')->nullable(); // For webhook signature verification
            $table->boolean('is_active')->default(true);
            $table->json('field_mapping')->nullable(); // Map webhook fields to order fields
            $table->json('settings')->nullable(); // Additional settings
            $table->timestamps();
        });

        Schema::create('webhook_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('webhook_source_id')->nullable()->constrained()->nullOnDelete();
            $table->string('event_type')->nullable(); // payment_success, form_submit, etc.
            $table->text('payload'); // Full webhook payload
            $table->string('status'); // success, failed, pending
            $table->text('error_message')->nullable();
            $table->foreignId('order_id')->nullable()->constrained()->nullOnDelete();
            $table->string('ip_address')->nullable();
            $table->timestamps();

            $table->index('created_at');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('webhook_logs');
        Schema::dropIfExists('webhook_sources');
    }
};
