<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('malaysia_postcodes', function (Blueprint $table) {
            $table->id();
            $table->string('postcode', 5)->unique()->index();
            $table->string('city')->index();
            $table->string('state')->index();
            $table->string('state_code', 3)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('malaysia_postcodes');
    }
};
