<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('tracking_number')->nullable()->after('shipping_method_title');
            $table->string('courier')->nullable()->after('tracking_number')->default('Pos Laju');
            $table->json('poslaju_response')->nullable()->after('courier');
            $table->timestamp('awb_generated_at')->nullable()->after('poslaju_response');
            $table->string('awb_status')->nullable()->after('awb_generated_at')->default('pending');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'tracking_number',
                'courier',
                'poslaju_response',
                'awb_generated_at',
                'awb_status'
            ]);
        });
    }
};
