<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->decimal('subtotal', 10, 2)->default(0)->after('total');
            $table->decimal('shipping_total', 10, 2)->default(0)->after('subtotal');
            $table->decimal('discount_total', 10, 2)->default(0)->after('shipping_total');
            $table->decimal('fee_total', 10, 2)->default(0)->after('discount_total');
            $table->json('fee_lines')->nullable()->after('fee_total');
            $table->json('shipping_lines')->nullable()->after('fee_lines');
            $table->string('shipping_method_title')->nullable()->after('shipping_lines');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'subtotal',
                'shipping_total',
                'discount_total',
                'fee_total',
                'fee_lines',
                'shipping_lines',
                'shipping_method_title'
            ]);
        });
    }
};
