<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('company_name')->nullable()->after('email');
            $table->string('company_registration')->nullable()->after('company_name');
            $table->text('company_address')->nullable()->after('company_registration');
            $table->string('company_city')->nullable()->after('company_address');
            $table->string('company_state')->nullable()->after('company_city');
            $table->string('company_postcode')->nullable()->after('company_state');
            $table->string('company_country')->default('Malaysia')->after('company_postcode');
            $table->string('company_phone')->nullable()->after('company_country');
            $table->string('company_email')->nullable()->after('company_phone');
            $table->string('company_website')->nullable()->after('company_email');
            $table->string('company_logo')->nullable()->after('company_website');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'company_name', 'company_registration', 'company_address',
                'company_city', 'company_state', 'company_postcode', 'company_country',
                'company_phone', 'company_email', 'company_website', 'company_logo'
            ]);
        });
    }
};
