<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('stores', function (Blueprint $table) {
            $table->string('webhook_secret')->nullable()->after('consumer_secret');
            $table->json('webhook_ids')->nullable()->after('webhook_secret');
            $table->boolean('webhooks_enabled')->default(false)->after('webhook_ids');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('stores', function (Blueprint $table) {
            $table->dropColumn(['webhook_secret', 'webhook_ids', 'webhooks_enabled']);
        });
    }
};
