<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('stores', function (Blueprint $table) {
            $table->string('store_prefix', 10)->unique()->after('name');
        });
        
        // Generate prefixes for existing stores
        $stores = DB::table('stores')->get();
        foreach ($stores as $index => $store) {
            $prefix = $this->generatePrefix($store->name, $store->id);
            DB::table('stores')
                ->where('id', $store->id)
                ->update(['store_prefix' => $prefix]);
        }
    }

    public function down()
    {
        Schema::table('stores', function (Blueprint $table) {
            $table->dropColumn('store_prefix');
        });
    }
    
    private function generatePrefix($name, $id)
    {
        // Generate a 3-letter prefix from store name
        $prefix = strtoupper(substr(preg_replace('/[^A-Za-z0-9]/', '', $name), 0, 3));
        if (strlen($prefix) < 3) {
            $prefix = str_pad($prefix, 3, $id);
        }
        return $prefix . $id;
    }
};