<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('store_id');
            $table->integer('woo_order_id');
            $table->string('order_number');
            $table->string('global_order_id')->unique(); // New unique identifier
            $table->string('status');
            $table->decimal('total', 10, 2);
            $table->string('currency', 3);
            $table->string('payment_method');
            $table->string('payment_method_title');
            $table->json('billing')->nullable();
            $table->json('shipping')->nullable();
            $table->json('line_items')->nullable();
            $table->json('meta_data')->nullable();
            $table->timestamp('date_created');
            $table->timestamp('date_modified')->nullable();
            $table->timestamps();
            
            $table->foreign('store_id')->references('id')->on('stores')->onDelete('cascade');
            $table->index(['store_id', 'status']);
            $table->index('payment_method');
            $table->index('global_order_id'); // Index for fast lookups
            $table->unique(['store_id', 'woo_order_id']); // Ensure uniqueness per store
        });
    }

    public function down()
    {
        Schema::dropIfExists('orders');
    }
};