<?php

return [

    /*
    |--------------------------------------------------------------------------
    | PWA Domain Configuration
    |--------------------------------------------------------------------------
    |
    | Configure PWA settings for each domain/tenant using the system.
    | The manifest.json will be generated dynamically based on the domain.
    |
    */

    'domains' => [
        'mamadil.team' => [
            'name' => 'Omnia',
            'short_name' => 'Omnia',
            'description' => 'Real-time order notifications for Mamadil.team',
            'theme_color' => '#4F46E5',
            'background_color' => '#ffffff',
        ],
        'www.mamadil.team' => [
            'name' => 'Omnia',
            'short_name' => 'Omnia',
            'description' => 'Real-time order notifications for Mamadil.team',
            'theme_color' => '#4F46E5',
            'background_color' => '#ffffff',
        ],
        'multistore.test' => [
            'name' => 'Omnia',
            'short_name' => 'Omnia',
            'description' => 'Multi-channel order management system',
            'theme_color' => '#4F46E5',
            'background_color' => '#ffffff',
        ],
        'localhost' => [
            'name' => 'Omnia',
            'short_name' => 'Omnia',
            'description' => 'Multi-channel order management system',
            'theme_color' => '#4F46E5',
            'background_color' => '#ffffff',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Default PWA Settings
    |--------------------------------------------------------------------------
    |
    | Used when domain is not found in the domains array above.
    |
    */

    'default' => [
        'name' => 'Omnia',
        'short_name' => 'Omnia',
        'description' => 'Real-time order notifications',
        'theme_color' => '#4F46E5',
        'background_color' => '#ffffff',
    ],

    /*
    |--------------------------------------------------------------------------
    | PWA Icons
    |--------------------------------------------------------------------------
    |
    | Shared icon configuration for all domains.
    | Icons should be placed in public/icons/ directory.
    |
    */

    'icons' => [
        ['src' => '/icons/icon-72.png', 'sizes' => '72x72', 'type' => 'image/png', 'purpose' => 'any'],
        ['src' => '/icons/icon-96.png', 'sizes' => '96x96', 'type' => 'image/png', 'purpose' => 'any'],
        ['src' => '/icons/icon-128.png', 'sizes' => '128x128', 'type' => 'image/png', 'purpose' => 'any'],
        ['src' => '/icons/icon-144.png', 'sizes' => '144x144', 'type' => 'image/png', 'purpose' => 'any'],
        ['src' => '/icons/icon-152.png', 'sizes' => '152x152', 'type' => 'image/png', 'purpose' => 'any'],
        ['src' => '/icons/icon-192.png', 'sizes' => '192x192', 'type' => 'image/png', 'purpose' => 'any maskable'],
        ['src' => '/icons/icon-384.png', 'sizes' => '384x384', 'type' => 'image/png', 'purpose' => 'any'],
        ['src' => '/icons/icon-512.png', 'sizes' => '512x512', 'type' => 'image/png', 'purpose' => 'any maskable'],
    ],

    /*
    |--------------------------------------------------------------------------
    | Notification Sounds
    |--------------------------------------------------------------------------
    |
    | Sound files for different notification types.
    | Files should be placed in public/sounds/ directory.
    |
    */

    'sounds' => [
        'default' => '/sounds/kaching.mp3',
        'high_value' => '/sounds/big-win.mp3',        // Orders > RM500
        'first_of_day' => '/sounds/kaching.mp3', // First order of the day
    ],

    /*
    |--------------------------------------------------------------------------
    | High Value Order Threshold
    |--------------------------------------------------------------------------
    |
    | Minimum order amount to trigger "high value" notification sound.
    |
    */

    'high_value_threshold' => 500, // RM500

];
