<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Pos Laju API Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for Pos Laju API integration for generating AWB
    | (Air Waybill) consignment numbers and tracking shipments.
    |
    */

    'api_url' => env('POSLAJU_API_URL', 'https://api.pos.com.my'),

    'credentials' => [
        'account_number' => env('POSLAJU_ACCOUNT_NUMBER'),
        'app_code' => env('POSLAJU_APP_CODE'),
        'secret_code' => env('POSLAJU_SECRET_CODE'),
        'client_id' => env('POSLAJU_CLIENT_ID'),
        'client_secret' => env('POSLAJU_CLIENT_SECRET'),
    ],

    // API Required Configuration
    'api_config' => [
        'product_code' => env('POSLAJU_PRODUCT_CODE', 'PL'),
        'subscription_code' => env('POSLAJU_SUBSCRIPTION_CODE'),
        'item_type' => env('POSLAJU_ITEM_TYPE', 'Parcel'), // Parcel or Document
        'service_level' => env('POSLAJU_SERVICE_LEVEL', 'Standard'), // Standard or Express
        'order_validity' => env('POSLAJU_ORDER_VALIDITY', 1), // Days (1-30)
        'webhook_required' => env('POSLAJU_WEBHOOK_REQUIRED', false),
    ],

    'sender' => [
        'name' => env('POSLAJU_SENDER_NAME'),
        'phone' => env('POSLAJU_SENDER_PHONE'),
        'address' => env('POSLAJU_SENDER_ADDRESS'),
        'postcode' => env('POSLAJU_SENDER_POSTCODE'),
        'city' => env('POSLAJU_SENDER_CITY'),
        'state' => env('POSLAJU_SENDER_STATE'),
        'country' => 'MY',
    ],

    // Default parcel details
    'defaults' => [
        'weight' => 1.0, // kg
        'length' => 20, // cm
        'width' => 15, // cm
        'height' => 10, // cm
        'service_type' => 'POS LAJU', // or 'PREPAID', 'EMS', etc.
        'payment_method' => 'CREDIT', // CREDIT or COD
    ],
];
