<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Performance Optimization Settings
    |--------------------------------------------------------------------------
    |
    | These settings control various performance optimizations throughout
    | the application for both MySQL and MariaDB databases.
    |
    */

    // Enable query result caching
    'cache_queries' => env('CACHE_QUERIES', true),

    // Cache TTL in seconds (default: 5 minutes for real-time data)
    'cache_ttl' => env('CACHE_TTL', 300),

    // Dashboard stats cache TTL (default: 1 minute)
    'dashboard_cache_ttl' => env('DASHBOARD_CACHE_TTL', 60),

    // Enable eager loading by default
    'eager_loading' => true,

    // Pagination defaults
    'pagination' => [
        'per_page' => 25,
        'max_per_page' => 100,
    ],

    // Database query optimization
    'database' => [
        // Use chunking for large result sets
        'chunk_size' => 1000,

        // Enable query logging in development only
        'log_queries' => env('LOG_QUERIES', false),

        // Slow query threshold (milliseconds)
        'slow_query_threshold' => env('SLOW_QUERY_THRESHOLD', 1000),
    ],

    // Session optimization
    'session' => [
        // Use database driver for better performance with multiple servers
        'driver' => env('SESSION_DRIVER', 'database'),

        // Session lifetime in minutes
        'lifetime' => env('SESSION_LIFETIME', 120),
    ],

    // View caching
    'views' => [
        // Enable view caching in production
        'cache' => env('VIEW_CACHE', true),
    ],

];
