<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Invoice Configuration
    |--------------------------------------------------------------------------
    |
    | This configuration file contains settings for the invoice system
    | including company information, styling options, and integration settings.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Company Information
    |--------------------------------------------------------------------------
    |
    | Configure your company details that will appear on invoices
    |
    */
    'company' => [
        'name' => env('INVOICE_COMPANY_NAME', 'Mamadil & Slim Beauty Sdn Bhd'),
        'subtitle' => env('INVOICE_COMPANY_SUBTITLE', 'Team Mus (Sales Team)'),
        'logo' => env('INVOICE_COMPANY_LOGO', null), // Path to logo image
        'address' => env('INVOICE_COMPANY_ADDRESS', "PT 35478 Dataran Austin, Jalan Austin,\n21300, Kuala Terengganu"),
        'city' => env('INVOICE_COMPANY_CITY', 'Kuala Terengganu'),
        'state' => env('INVOICE_COMPANY_STATE', 'Terengganu'),
        'postal_code' => env('INVOICE_COMPANY_POSTAL', '21300'),
        'country' => env('INVOICE_COMPANY_COUNTRY', 'Malaysia'),
        'phone' => env('INVOICE_COMPANY_PHONE', null),
        'email' => env('INVOICE_COMPANY_EMAIL', null),
        'website' => env('INVOICE_COMPANY_WEBSITE', null),
        'tax_number' => env('INVOICE_COMPANY_TAX', null),
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Settings
    |--------------------------------------------------------------------------
    |
    | Default values for invoice generation
    |
    */
    'defaults' => [
        'currency' => env('INVOICE_DEFAULT_CURRENCY', 'RM'),
        'country_code' => env('INVOICE_DEFAULT_COUNTRY_CODE', '60'),
        'courier' => env('INVOICE_DEFAULT_COURIER', 'Poslaju (Malaysia)'),
        'shipping_method' => env('INVOICE_DEFAULT_SHIPPING', 'Standard'),
        'tax_rate' => env('INVOICE_DEFAULT_TAX_RATE', 0),
        'date_format' => env('INVOICE_DATE_FORMAT', 'Y-m-d H:i:s'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Status Color Configuration
    |--------------------------------------------------------------------------
    |
    | Define colors for different order statuses
    |
    */
    'status_colors' => [
        'processing' => [
            'class' => 'status-warning',
            'bg' => '#fef3c7',
            'text' => '#92400e',
            'print_safe' => true,
        ],
        'completed' => [
            'class' => 'status-success',
            'bg' => '#dcfce7',
            'text' => '#166534',
            'print_safe' => true,
        ],
        'pending' => [
            'class' => 'status-secondary',
            'bg' => '#f3f4f6',
            'text' => '#374151',
            'print_safe' => true,
        ],
        'on-hold' => [
            'class' => 'status-warning',
            'bg' => '#fef3c7',
            'text' => '#92400e',
            'print_safe' => true,
        ],
        'cancelled' => [
            'class' => 'status-danger',
            'bg' => '#fee2e2',
            'text' => '#991b1b',
            'print_safe' => true,
        ],
        'refunded' => [
            'class' => 'status-info',
            'bg' => '#dbeafe',
            'text' => '#1e40af',
            'print_safe' => true,
        ],
        'failed' => [
            'class' => 'status-danger',
            'bg' => '#fee2e2',
            'text' => '#991b1b',
            'print_safe' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Payment Method Colors
    |--------------------------------------------------------------------------
    |
    | Define colors for different payment methods
    |
    */
    'payment_colors' => [
        'cod' => [
            'class' => 'status-warning',
            'bg' => '#fef3c7',
            'text' => '#92400e',
            'name' => 'Cash on Delivery',
        ],
        'bacs' => [
            'class' => 'status-info',
            'bg' => '#dbeafe',
            'text' => '#1e40af',
            'name' => 'Bank Transfer',
        ],
        'stripe' => [
            'class' => 'status-success',
            'bg' => '#dcfce7',
            'text' => '#166534',
            'name' => 'Stripe',
        ],
        'paypal' => [
            'class' => 'status-info',
            'bg' => '#dbeafe',
            'text' => '#1e40af',
            'name' => 'PayPal',
        ],
        'visa' => [
            'class' => 'status-info',
            'bg' => '#dbeafe',
            'text' => '#1e40af',
            'name' => 'Visa / Mastercard',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | WhatsApp Integration
    |--------------------------------------------------------------------------
    |
    | Settings for WhatsApp integration
    |
    */
    'whatsapp' => [
        'enabled' => env('INVOICE_WHATSAPP_ENABLED', true),
        'default_country_code' => env('INVOICE_WHATSAPP_COUNTRY_CODE', '60'),
        'default_message' => env('INVOICE_WHATSAPP_MESSAGE', ''),
        'icon_size' => env('INVOICE_WHATSAPP_ICON_SIZE', '12'),
        'target_blank' => env('INVOICE_WHATSAPP_TARGET_BLANK', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Print Settings
    |--------------------------------------------------------------------------
    |
    | Configuration for print layouts and styling
    |
    */
    'print' => [
        'paper_size' => env('INVOICE_PRINT_PAPER_SIZE', 'A4'),
        'orientation' => env('INVOICE_PRINT_ORIENTATION', 'portrait'),
        'margin_top' => env('INVOICE_PRINT_MARGIN_TOP', '0'),
        'margin_right' => env('INVOICE_PRINT_MARGIN_RIGHT', '0'),
        'margin_bottom' => env('INVOICE_PRINT_MARGIN_BOTTOM', '0'),
        'margin_left' => env('INVOICE_PRINT_MARGIN_LEFT', '0'),
        'color_mode' => env('INVOICE_PRINT_COLOR_MODE', 'color'), // color, grayscale, or monochrome
        'quality' => env('INVOICE_PRINT_QUALITY', 'high'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Invoice Layout
    |--------------------------------------------------------------------------
    |
    | Layout configuration for different sections
    |
    */
    'layout' => [
        'header_height_percent' => 25,
        'details_height_percent' => 25,
        'items_height_percent' => 50,
        'show_company_logo' => env('INVOICE_SHOW_LOGO', true),
        'show_edit_buttons' => env('INVOICE_SHOW_EDIT_BUTTONS', true),
        'show_whatsapp_links' => env('INVOICE_SHOW_WHATSAPP', true),
        'show_tracking_number' => env('INVOICE_SHOW_TRACKING', true),
        'show_order_notes' => env('INVOICE_SHOW_NOTES', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Localization
    |--------------------------------------------------------------------------
    |
    | Language and formatting settings
    |
    */
    'localization' => [
        'currency_symbol' => env('INVOICE_CURRENCY_SYMBOL', 'RM'),
        'currency_position' => env('INVOICE_CURRENCY_POSITION', 'before'), // before or after
        'thousand_separator' => env('INVOICE_THOUSAND_SEPARATOR', ','),
        'decimal_separator' => env('INVOICE_DECIMAL_SEPARATOR', '.'),
        'decimal_places' => env('INVOICE_DECIMAL_PLACES', 2),
        'date_format' => env('INVOICE_DATE_FORMAT', 'Y-m-d H:i:s'),
        'timezone' => env('INVOICE_TIMEZONE', 'Asia/Kuala_Lumpur'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Feature Flags
    |--------------------------------------------------------------------------
    |
    | Enable or disable specific features
    |
    */
    'features' => [
        'auto_print' => env('INVOICE_AUTO_PRINT', false),
        'download_pdf' => env('INVOICE_DOWNLOAD_PDF', false),
        'email_invoice' => env('INVOICE_EMAIL_ENABLED', false),
        'invoice_numbering' => env('INVOICE_CUSTOM_NUMBERING', false),
        'qr_code' => env('INVOICE_QR_CODE', false),
        'barcode' => env('INVOICE_BARCODE', false),
        'watermark' => env('INVOICE_WATERMARK', false),
    ],

    /*
    |--------------------------------------------------------------------------
    | Security
    |--------------------------------------------------------------------------
    |
    | Security settings for invoice access
    |
    */
    'security' => [
        'require_auth' => env('INVOICE_REQUIRE_AUTH', true),
        'allowed_roles' => ['admin', 'manager', 'staff'],
        'rate_limit' => env('INVOICE_RATE_LIMIT', 60), // requests per minute
        'csrf_protection' => env('INVOICE_CSRF_PROTECTION', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Fields
    |--------------------------------------------------------------------------
    |
    | Additional fields that can be displayed on invoices
    |
    */
    'custom_fields' => [
        'show_sku' => env('INVOICE_SHOW_SKU', true),
        'show_weight' => env('INVOICE_SHOW_WEIGHT', false),
        'show_dimensions' => env('INVOICE_SHOW_DIMENSIONS', false),
        'show_tax_breakdown' => env('INVOICE_SHOW_TAX_BREAKDOWN', true),
        'show_discount' => env('INVOICE_SHOW_DISCOUNT', true),
        'show_shipping_method' => env('INVOICE_SHOW_SHIPPING_METHOD', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | API Settings
    |--------------------------------------------------------------------------
    |
    | Settings for API integrations
    |
    */
    'api' => [
        'webhook_url' => env('INVOICE_WEBHOOK_URL', null),
        'webhook_secret' => env('INVOICE_WEBHOOK_SECRET', null),
        'external_service' => env('INVOICE_EXTERNAL_SERVICE', null),
        'timeout' => env('INVOICE_API_TIMEOUT', 30),
    ],
];
