<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
        then: function () {
            Route::middleware('web')
                ->group(base_path('routes/invoice.php'));
        },
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Register middleware alias for admin role check
        $middleware->alias([
            'admin' => \App\Http\Middleware\EnsureUserIsAdmin::class,
            'tiktok.access' => \App\Http\Middleware\EnsureTikTokShopAccess::class,
        ]);

        // Add custom domain detection and maintenance mode check to web middleware group
        $middleware->web(append: [
            \App\Http\Middleware\DetectCustomDomain::class,
            \App\Http\Middleware\CheckForAdminDuringMaintenance::class,
        ]);

        // Exclude webhook and payment callback routes from CSRF verification
        $middleware->validateCsrfTokens(except: [
            'webhook/*',
            '/webhook/*',
            '/payment/return',
            '/payment/callback',
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
