<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Order;
use App\Observers\OrderObserver;
use App\Models\SystemSetting;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register Order observer for WhatsApp notifications
        Order::observe(OrderObserver::class);

        // Set application timezone from database settings
        try {
            $timezone = SystemSetting::get('app_timezone', config('app.timezone', 'Asia/Kuala_Lumpur'));
            if ($timezone) {
                Config::set('app.timezone', $timezone);
                date_default_timezone_set($timezone);
            }
        } catch (\Exception $e) {
            // If database is not available (migrations not run yet), use config default
            // This prevents errors during fresh installation
        }
    }
}
