<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WhatsAppSetting extends Model
{
    protected $table = 'whatsapp_settings';

    protected $fillable = [
        'user_id',
        'provider',
        'api_url',
        'api_key',
        'api_secret',
        'phone_number_id',
        'business_account_id',
        'access_token',
        // WasapBot.my fields
        'wasapbot_instance_id',
        'wasapbot_port',
        'wasapbot_phone_number',
        // Notification triggers
        'notify_on_order_created',
        'notify_on_order_processing',
        'notify_on_order_completed',
        'notify_on_order_cancelled',
        'notify_on_awb_generated',
        // Message templates
        'template_order_created',
        'template_order_processing',
        'template_order_completed',
        'template_order_cancelled',
        'template_awb_generated',
        'is_active',
        'sender_name',
    ];

    protected $casts = [
        'notify_on_order_created' => 'boolean',
        'notify_on_order_processing' => 'boolean',
        'notify_on_order_completed' => 'boolean',
        'notify_on_order_cancelled' => 'boolean',
        'notify_on_awb_generated' => 'boolean',
        'is_active' => 'boolean',
    ];

    /**
     * Get the user that owns the WhatsApp settings
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get default message templates
     */
    public static function getDefaultTemplates(): array
    {
        return [
            'order_created' => "Salam {customer_name}\n\nTerima kasih kerana sudi membeli produk {store_name}. Semoga beri manfaat untuk kalian.💜\n\nBerikut adalah maklumat tempahan:-\n\nID Tempahan: #{order_number}\nNama: {customer_name}\nAlamat: {address}\nNo Tel: {customer_contact}\nEmel: {email}\nProduk: {product_list}\n\nAdakah maklumat di atas tepat atau sebaliknya?\n\nBalas YA atau TIDAK untuk pengesahan.\n\nTerima kasih.",

            'order_processing' => "Hello {customer_name}! 📦\n\nYour order #{order_number} is now being processed.\n\nWe'll notify you once it's shipped!\n\n- {store_name}",

            'order_completed' => "Hello {customer_name}! ✅\n\nYour order #{order_number} has been completed.\n\nTracking Number: {tracking_number}\nCourier: {courier}\n\nTrack your shipment: {tracking_url}\n\nThank you for your purchase!\n\n- {store_name}",

            'order_cancelled' => "Hello {customer_name},\n\nYour order #{order_number} has been cancelled.\n\nIf you have any questions, please contact us.\n\n- {store_name}",

            'awb_generated' => "Salam {customer_name}\n\nTempahan anda: {product_list} sedang diproses.\nID Tempahan: #{order_number}\nNO TRACKING: {tracking_number}\n\nBoleh semak status tempahan di sini: {tracking_url}\n\nPerhatian kepada pelanggan cash on delivery (COD) sahaja, mohon sediakan wang secukupnya bagi melancarkan proses penerimaan barang.\n\nTerima kasih🥰",
        ];
    }

    /**
     * Available template variables
     */
    public static function getTemplateVariables(): array
    {
        return [
            '{customer_name}' => 'Customer full name',
            '{order_number}' => 'Order number',
            '{global_order_id}' => 'Global order ID',
            '{status}' => 'Order status',
            '{total}' => 'Order total amount',
            '{currency}' => 'Currency code',
            '{address}' => 'Customer full address',
            '{customer_contact}' => 'Customer phone number',
            '{email}' => 'Customer email address',
            '{product_list}' => 'List of products ordered',
            '{tracking_number}' => 'Courier tracking number',
            '{courier}' => 'Courier service name',
            '{tracking_url}' => 'Tracking URL',
            '{store_name}' => 'Store name',
            '{date}' => 'Current date',
        ];
    }
}
