<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WebhookLog extends Model
{
    protected $fillable = [
        'webhook_source_id',
        'event_type',
        'payload',
        'status',
        'error_message',
        'order_id',
        'ip_address',
    ];

    protected $casts = [
        'payload' => 'array',
    ];

    public function webhookSource()
    {
        return $this->belongsTo(WebhookSource::class);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Get formatted payload for display
     */
    public function getFormattedPayloadAttribute()
    {
        return json_encode($this->payload, JSON_PRETTY_PRINT);
    }

    /**
     * Scope for successful logs
     */
    public function scopeSuccessful($query)
    {
        return $query->where('status', 'success');
    }

    /**
     * Scope for failed logs
     */
    public function scopeFailed($query)
    {
        return $query->where('status', 'failed');
    }
}
