<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TikTokShop extends Model
{
    use HasFactory;

    protected $table = 'tiktok_shops';

    protected $fillable = [
        'name',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the users assigned to this TikTok Shop
     */
    public function users()
    {
        return $this->belongsToMany(User::class, 'tiktok_shop_user', 'tiktok_shop_id', 'user_id')
            ->withTimestamps();
    }

    /**
     * Get all transactions for this TikTok Shop
     */
    public function transactions()
    {
        return $this->hasMany(TikTokTransaction::class, 'tiktok_shop_id');
    }

    /**
     * Get all ads transactions for this TikTok Shop
     */
    public function adsTransactions()
    {
        return $this->hasMany(TikTokAdsTransaction::class, 'tiktok_shop_id');
    }

    /**
     * Scope: Only active shops
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
