<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SalesTarget extends Model
{
    protected $fillable = [
        'user_id',
        'year',
        'month',
        'target_revenue',
        'target_orders',
        'target_aov',
        'actual_revenue',
        'actual_orders',
        'actual_aov',
        'achievement_percent',
        'forecast_revenue',
        'status',
    ];

    protected $casts = [
        'target_revenue' => 'decimal:2',
        'target_orders' => 'integer',
        'target_aov' => 'decimal:2',
        'actual_revenue' => 'decimal:2',
        'actual_orders' => 'integer',
        'actual_aov' => 'decimal:2',
        'achievement_percent' => 'decimal:2',
        'forecast_revenue' => 'decimal:2',
        'year' => 'integer',
        'month' => 'integer',
    ];

    /**
     * Get the user (seller/manager) this target belongs to
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get month name
     */
    public function getMonthNameAttribute()
    {
        return date('F', mktime(0, 0, 0, $this->month, 1));
    }

    /**
     * Check if target is met
     */
    public function getIsMetAttribute()
    {
        return $this->achievement_percent >= 100;
    }

    /**
     * Get variance amount
     */
    public function getVarianceAttribute()
    {
        return $this->actual_revenue - $this->target_revenue;
    }
}
