<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SalesPagePayment extends Model
{
    protected $fillable = [
        'sales_page_order_id',
        'payment_method',
        'bayarcash_order_number',
        'bayarcash_payment_url',
        'status',
        'amount',
        'transaction_data',
        'paid_at',
        'expires_at',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'transaction_data' => 'array',
        'paid_at' => 'datetime',
        'expires_at' => 'datetime',
    ];

    /**
     * Get the order that owns this payment
     */
    public function salesPageOrder(): BelongsTo
    {
        return $this->belongsTo(SalesPageOrder::class);
    }

    /**
     * Check if payment is paid
     */
    public function isPaid(): bool
    {
        return $this->status === 'paid';
    }

    /**
     * Check if payment is pending
     */
    public function isPending(): bool
    {
        return $this->status === 'pending';
    }

    /**
     * Check if payment has expired
     */
    public function isExpired(): bool
    {
        return $this->status === 'expired' ||
               ($this->expires_at && $this->expires_at->isPast());
    }

    /**
     * Check if payment is COD
     */
    public function isCod(): bool
    {
        return $this->payment_method === 'cod';
    }
}
