<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class SalesPageOrder extends Model
{
    protected $fillable = [
        'sales_page_id',
        'order_id',
        'customer_name',
        'customer_email',
        'customer_phone',
        'customer_address',
        'customer_city',
        'customer_state',
        'customer_postcode',
        'items',
        'total_amount',
        'payment_method',
        'payment_status',
        'cod_fee',
        'grand_total',
        'session_id',
        'utm_data',
        'status',
    ];

    protected $casts = [
        'items' => 'array',
        'utm_data' => 'array',
        'total_amount' => 'decimal:2',
        'cod_fee' => 'decimal:2',
        'grand_total' => 'decimal:2',
    ];

    /**
     * Get the sales page that owns this order
     */
    public function salesPage(): BelongsTo
    {
        return $this->belongsTo(SalesPage::class);
    }

    /**
     * Get the main order record (if created)
     */
    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Get the payment record for this order
     */
    public function payment(): HasOne
    {
        return $this->hasOne(SalesPagePayment::class);
    }

    /**
     * Check if order is COD
     */
    public function isCod(): bool
    {
        return $this->payment_method === 'cod';
    }

    /**
     * Check if payment is complete
     */
    public function isPaid(): bool
    {
        return $this->payment_status === 'paid';
    }
}
