<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SalesPageAnalytics extends Model
{
    public $timestamps = false; // We only use created_at

    protected $fillable = [
        'sales_page_id',
        'event_type',
        'session_id',
        'ip_address',
        'user_agent',
        'referrer',
        'utm_source',
        'utm_medium',
        'utm_campaign',
        'utm_content',
        'device_type',
        'browser',
        'os',
    ];

    /**
     * Get the sales page that owns this analytics record
     */
    public function salesPage(): BelongsTo
    {
        return $this->belongsTo(SalesPage::class);
    }
}
