<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MarketingCampaign extends Model
{
    protected $fillable = [
        'name',
        'description',
        'start_date',
        'end_date',
        'budget',
        'target_revenue',
        'actual_revenue',
        'orders_count',
        'roi',
        'status',
        'created_by',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'budget' => 'decimal:2',
        'target_revenue' => 'decimal:2',
        'actual_revenue' => 'decimal:2',
        'orders_count' => 'integer',
        'roi' => 'decimal:2',
    ];

    /**
     * Get the user who created this campaign
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Check if campaign is currently active
     */
    public function getIsActiveAttribute()
    {
        $today = now()->toDateString();
        return $this->start_date <= $today && $this->end_date >= $today;
    }
}
