<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MalaysiaPostcode extends Model
{
    protected $fillable = ['postcode', 'city', 'state', 'state_code'];

    /**
     * Get state by postcode
     */
    public static function getStateByPostcode($postcode)
    {
        $record = self::where('postcode', $postcode)->first();
        return $record ? $record->state : null;
    }

    /**
     * Get state code by postcode
     */
    public static function getStateCodeByPostcode($postcode)
    {
        $record = self::where('postcode', $postcode)->first();
        return $record ? $record->state_code : null;
    }

    /**
     * Validate if postcode matches state
     */
    public static function validatePostcodeState($postcode, $state)
    {
        $record = self::where('postcode', $postcode)->first();

        if (!$record) {
            return false; // Invalid postcode
        }

        // Normalize state names for comparison
        $normalizedState = strtolower(trim($state));
        $normalizedRecordState = strtolower(trim($record->state));

        return $normalizedState === $normalizedRecordState;
    }

    /**
     * Get city by postcode
     */
    public static function getCityByPostcode($postcode)
    {
        $record = self::where('postcode', $postcode)->first();
        return $record ? $record->city : null;
    }
}
