<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class KpiMetric extends Model
{
    protected $fillable = [
        'user_id',
        'year',
        'month',
        'revenue_target',
        'revenue_actual',
        'orders_target',
        'orders_actual',
        'aov_target',
        'aov_actual',
        'conversion_rate',
        'repeat_customer_rate',
        'fulfillment_rate',
        'kpi_score',
        'performance_grade',
    ];

    protected $casts = [
        'revenue_target' => 'decimal:2',
        'revenue_actual' => 'decimal:2',
        'orders_target' => 'integer',
        'orders_actual' => 'integer',
        'aov_target' => 'decimal:2',
        'aov_actual' => 'decimal:2',
        'conversion_rate' => 'decimal:2',
        'repeat_customer_rate' => 'decimal:2',
        'fulfillment_rate' => 'decimal:2',
        'kpi_score' => 'decimal:2',
        'year' => 'integer',
        'month' => 'integer',
    ];

    /**
     * Get the user this KPI belongs to
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get month name
     */
    public function getMonthNameAttribute()
    {
        return date('F', mktime(0, 0, 0, $this->month, 1));
    }
}
