<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HistoricalSale extends Model
{
    protected $fillable = [
        'year',
        'month',
        'revenue',
        'orders',
        'expenses',
        'stokis_sales',
        'agent_sales',
        'hq_sales',
        'import_source',
        'notes',
        'created_by',
        'expense_updated_at',
        'expense_updated_by',
    ];

    protected $casts = [
        'revenue' => 'decimal:2',
        'aov' => 'decimal:2',
        'expenses' => 'decimal:2',
        'net_profit' => 'decimal:2',
        'stokis_sales' => 'decimal:2',
        'agent_sales' => 'decimal:2',
        'hq_sales' => 'decimal:2',
        'orders' => 'integer',
        'year' => 'integer',
        'month' => 'integer',
    ];

    /**
     * Get the user who created this record
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get month name
     */
    public function getMonthNameAttribute()
    {
        return date('F', mktime(0, 0, 0, $this->month, 1));
    }

    /**
     * Get formatted period
     */
    public function getPeriodAttribute()
    {
        return $this->month_name . ' ' . $this->year;
    }
}
