<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ForecastSuggestion extends Model
{
    protected $fillable = [
        'user_id',
        'year',
        'month',
        'suggestion_type',
        'title',
        'description',
        'expected_impact',
        'priority',
        'status',
    ];

    protected $casts = [
        'year' => 'integer',
        'month' => 'integer',
    ];

    /**
     * Get the user this suggestion is for
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get month name
     */
    public function getMonthNameAttribute()
    {
        return date('F', mktime(0, 0, 0, $this->month, 1));
    }
}
