<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    protected $fillable = [
        'username',
        'password',
        'phone',
        'first_name',
        'last_name',
        'email',
        'address_1',
        'address_2',
        'city',
        'state',
        'postcode',
        'country',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the full name attribute (first_name + last_name)
     */
    public function getNameAttribute(): string
    {
        return trim($this->first_name . ' ' . $this->last_name);
    }

    /**
     * Get the address attribute (address_1)
     */
    public function getAddressAttribute(): ?string
    {
        return $this->address_1;
    }

    /**
     * Get all orders for this customer
     */
    public function orders()
    {
        return $this->hasMany(Order::class, 'customer_id');
    }
}
