<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureTikTokShopAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        // Check if user is authenticated
        if (!$user) {
            abort(403, 'Unauthorized. Authentication required.');
        }

        // Allow if user is admin OR manager with TikTok Shop access
        $hasAccess = $user->role === 'admin' ||
                    ($user->role === 'manager' && $user->can_manage_tiktok_shop);

        if (!$hasAccess) {
            abort(403, 'Unauthorized. TikTok Shop access required.');
        }

        return $next($request);
    }
}
