<?php

namespace App\Http\Middleware;

use App\Models\SystemSetting;
use Closure;
use Illuminate\Http\Request;

class CheckForAdminDuringMaintenance
{
    /**
     * Handle an incoming request.
     *
     * Custom soft maintenance mode that allows admins to bypass.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if soft maintenance mode is enabled
        $maintenanceMode = SystemSetting::get('soft_maintenance_mode', 'false');

        if ($maintenanceMode === 'true') {
            // Allow access if user is authenticated and is admin
            if (auth()->check() && auth()->user()->isAdmin()) {
                return $next($request);
            }

            // Otherwise, show 503 maintenance page
            return response()->view('errors.503-maintenance', [
                'message' => SystemSetting::get('maintenance_message', 'System is currently under maintenance. We\'ll be back shortly.')
            ], 503);
        }

        return $next($request);
    }
}
