<?php

namespace App\Http\Controllers;

use App\Models\WhatsAppSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WhatsAppSettingsController extends Controller
{
    public function index()
    {
        $settings = WhatsAppSetting::where('user_id', Auth::id())->first();

        return view('whatsapp-settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'provider' => 'required|in:official,wasapbot,twilio,wati,webhook',
            'access_token' => 'nullable|string',
            'phone_number_id' => 'nullable|string',
            'business_account_id' => 'nullable|string',
            'wasapbot_instance_id' => 'nullable|string',
            'wasapbot_port' => 'nullable|string',
            'wasapbot_phone_number' => 'nullable|string',
            'api_url' => 'nullable|url',
            'api_key' => 'nullable|string',
            'api_secret' => 'nullable|string',
            'notify_on_order_created' => 'boolean',
            'notify_on_order_processing' => 'boolean',
            'notify_on_order_completed' => 'boolean',
            'notify_on_order_cancelled' => 'boolean',
            'notify_on_awb_generated' => 'boolean',
            'template_order_created' => 'nullable|string',
            'template_order_processing' => 'nullable|string',
            'template_order_completed' => 'nullable|string',
            'template_order_cancelled' => 'nullable|string',
            'template_awb_generated' => 'nullable|string',
            'is_active' => 'boolean',
            'sender_name' => 'nullable|string',
        ]);

        // Convert checkbox values
        $validated['notify_on_order_created'] = $request->has('notify_on_order_created');
        $validated['notify_on_order_processing'] = $request->has('notify_on_order_processing');
        $validated['notify_on_order_completed'] = $request->has('notify_on_order_completed');
        $validated['notify_on_order_cancelled'] = $request->has('notify_on_order_cancelled');
        $validated['notify_on_awb_generated'] = $request->has('notify_on_awb_generated');
        $validated['is_active'] = $request->has('is_active');

        WhatsAppSetting::updateOrCreate(
            ['user_id' => Auth::id()],
            $validated
        );

        return redirect()->route('whatsapp-settings.index')
            ->with('success', 'WhatsApp settings updated successfully!');
    }
}
