<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MalaysiaPostcode;

class PostcodeController extends Controller
{
    /**
     * Lookup city and state by postcode
     */
    public function lookup(Request $request)
    {
        $postcode = $request->get('postcode');

        if (!$postcode) {
            return response()->json([
                'success' => false,
                'message' => 'Postcode is required'
            ], 400);
        }

        // Clean postcode (remove spaces, dashes)
        $postcode = preg_replace('/[^0-9]/', '', $postcode);

        $record = MalaysiaPostcode::where('postcode', $postcode)->first();

        if (!$record) {
            return response()->json([
                'success' => false,
                'message' => 'Postcode not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => [
                'postcode' => $record->postcode,
                'city' => $record->city,
                'state' => $record->state,
                'state_code' => $record->state_code
            ]
        ]);
    }
}
