<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ManifestController extends Controller
{
    /**
     * Generate manifest.json dynamically based on domain
     */
    public function show(Request $request)
    {
        $host = $request->getHost();

        // Get PWA settings for this domain
        $domains = config('pwa.domains', []);
        $pwaConfig = $domains[$host] ?? config('pwa.default');

        $manifest = [
            'name' => $pwaConfig['name'],
            'short_name' => $pwaConfig['short_name'],
            'description' => $pwaConfig['description'],
            'start_url' => '/',
            'display' => 'standalone',
            'background_color' => $pwaConfig['background_color'],
            'theme_color' => $pwaConfig['theme_color'],
            'orientation' => 'portrait-primary',
            'icons' => config('pwa.icons', []),
            'categories' => ['business', 'productivity'],
            'screenshots' => [],
        ];

        return response()->json($manifest)
            ->header('Content-Type', 'application/manifest+json')
            ->header('Cache-Control', 'public, max-age=3600'); // Cache for 1 hour
    }
}
