<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule)
    {
        // Sync orders from WooCommerce stores every 5 minutes
        // This is a backup to webhooks - ensures no orders are missed
        $schedule->command('woo:sync-orders')
                 ->everyFiveMinutes()
                 ->withoutOverlapping()
                 ->runInBackground();

        // Clean up old export temp files every hour
        $schedule->command('exports:cleanup')->hourly();

        // Database optimization daily at 2 AM
        $schedule->command('db:optimize')->dailyAt('02:00');
    }

    protected function commands()
    {
        $this->load(__DIR__.'/Commands');
        require base_path('routes/console.php');
    }
}