<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class OptimizeDatabase extends Command
{
    protected $signature = 'db:optimize';
    protected $description = 'Optimize database tables and clean old logs';

    public function handle()
    {
        $this->info('Starting database optimization...');
        
        // Clean old logs (older than 30 days)
        DB::table('order_logs')
            ->where('created_at', '<', now()->subDays(30))
            ->delete();
        
        // Optimize tables
        $tables = ['orders', 'stores', 'order_logs'];
        foreach ($tables as $table) {
            DB::statement("OPTIMIZE TABLE {$table}");
            $this->info("Optimized table: {$table}");
        }
        
        // Clean expired sessions
        DB::table('sessions')
            ->where('last_activity', '<', now()->subHours(24))
            ->delete();
        
        $this->info('Database optimization completed!');
    }
}